// SketcherDoc.h : Interfejs klasy CSketcherDoc
//


#pragma once

#include"Elements.h"
class CSketcherDoc : public CDocument
{
protected: // Do tworzenia tylko z serializacji
	CSketcherDoc();
	DECLARE_DYNCREATE(CSketcherDoc)

// Atrybuty
public:

// Operacje
public:
   void DeleteElement(CElement* pElement); // Usu element
   unsigned int GetElementType()           // Pobierz typ elementu
         { return m_Element; }
   COLORREF GetElementColor()              // Pobierz kolor elementu
         { return m_Color; }
   void AddElement(CElement* pElement)     // Dodaj element do listy
   {
     m_ElementList.AddTail(pElement);
     SetModifiedFlag();                    // Ustaw flag modyfikacji
   }
   POSITION GetListHeadPosition()          // zwr pierwsz warto POSITION
      { return m_ElementList.GetHeadPosition(); }
   CElement* GetNext(POSITION& aPos)       // Zwraca wskanik do biecego elementu
      { return m_ElementList.GetNext(aPos); }
   void SendToBack(CElement* pElement);    // Przenie element do tyu w Z-order
   int GetPenWidth()                       // Pobierz biec szeroko pira
      { return m_PenWidth; }
   CSize GetDocSize()
   { return m_DocSize; }                   // Pobierz rozmiar dokumentu
  CRect GetDocExtent();                    // Pobierz prostokt ograniczajcy cay dokument

// Przesonicia
public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);

// Implementacja
public:
	virtual ~CSketcherDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Funkcje wygenerowanej mapy komunikatw
protected:
	DECLARE_MESSAGE_MAP()
public:
  afx_msg void OnColorBlack();
public:
  afx_msg void OnColorRed();
public:
  afx_msg void OnColorGreen();
public:
  afx_msg void OnColorBlue();
public:
  afx_msg void OnElementLine();
public:
  afx_msg void OnElementRectangle();
public:
  afx_msg void OnElementCircle();
public:
  afx_msg void OnElementCurve();
protected:
  // Current element type
  unsigned int m_Element;
  COLORREF m_Color;                                 // Biecy kolor rysowania
  CTypedPtrList<CObList, CElement*> m_ElementList;  // Lista elementw
  int m_PenWidth;                                   // Bieca szeroko pira
  CSize m_DocSize;                                  // Rozmiar dokumentu

public:
  afx_msg void OnUpdateColorBlack(CCmdUI *pCmdUI);
public:
  afx_msg void OnUpdateColorGreen(CCmdUI *pCmdUI);
public:
  afx_msg void OnUpdateColorRed(CCmdUI *pCmdUI);
public:
  afx_msg void OnUpdateColorBlue(CCmdUI *pCmdUI);
public:
  afx_msg void OnUpdateElementLine(CCmdUI *pCmdUI);
public:
  afx_msg void OnUpdateElementRectangle(CCmdUI *pCmdUI);
public:
  afx_msg void OnUpdateElementCircle(CCmdUI *pCmdUI);
public:
  afx_msg void OnUpdateElementCurve(CCmdUI *pCmdUI);
public:
  afx_msg void OnPenwidth();
public:
  afx_msg void OnElementText();
public:
  afx_msg void OnUpdateElementText(CCmdUI *pCmdUI);
};


